#include <QtGui>
#include <QtSql>
#include "MainForm.h"
#include "DatabaseTree.h"
#include "ConnectionForm.h"
#include "CodeTemplateTree.h"
#include "ResultTab.h"
#include "QueryTab.h"
#include "Highlighter.h"
#include "TableData.h"
#include "MainTextEdit.h"
#include "NumberLine.h"
#include "tablewidget.h"
#include "IntroModeSelectDlg.h"
#include "TextEdit.h"
#include "DebugModeValue.h"
#include "singleTableInfo.h"
#include "tableRelationDlg.h"

/* 
	    
*/
MainForm::MainForm(QWidget * parent, Qt::WindowFlags flags)
:QMainWindow(parent, flags)
{
	this->CreateDockWidget();
	this->CreateActions();
	this->CreateMenus();
	this->CreateToolbars();
	this->CreateStatusBar();
	
	this->SetLayout();
	
	connect(this, SIGNAL(destroyed()), (ConnectionForm*)(this->parent()), SLOT(CancelbuttonClick()));
}

/* 
	Dock Widget 
*/
void MainForm::CreateDockWidget()
{
	this->resultTab = new ResultTab(this);
	this->queryTab = new QueryTab();
	this->dock = new QDockWidget(tr("Databases"), this);

    this->folderView = new DatabaseTree(this->dock);
	this->folderView->setHeaderLabel("");
	this->folderView->MakeTreeView();
	
    this->dock->setWidget(this->folderView);
    addDockWidget(Qt::LeftDockWidgetArea, this->dock);

	// kang
    this->codeTemplateDock = new QDockWidget(tr("Code Template"), this);
    this->codeTemplate = new CodeTemplateTree(this->codeTemplateDock);
	this->codeTemplate->setHeaderLabel("");
	this->codeTemplate->MakeTreeView();
    this->codeTemplateDock->setWidget(this->codeTemplate);
    addDockWidget(Qt::LeftDockWidgetArea, this->codeTemplateDock);

    // Breakpoint Docking Viewer
	this->breakPointerInfo = new QDockWidget(tr("breakpointinfo"), this, Qt::Widget);
	this->breakPointerInfo->setAllowedAreas(Qt::BottomDockWidgetArea | Qt::RightDockWidgetArea);
	this->breakPointInfoTable = new tablewidget(this->breakPointerInfo);
	this->breakPointerInfo->setWidget(breakPointInfoTable);
	this->addDockWidget(Qt::RightDockWidgetArea, this->breakPointerInfo);
	this->breakPointerInfo->setVisible(false);
	
	// Call Stack Docking Viewer
	this->callStack = new QDockWidget(tr("Call Stack"), this, Qt::Widget);
	this->callStack->setAllowedAreas(Qt::BottomDockWidgetArea | Qt::RightDockWidgetArea);
	this->callStackInfoTable = new tablewidget1(this->callStack);
	this->callStack->setWidget(this->callStackInfoTable);
	addDockWidget(Qt::RightDockWidgetArea, this->callStack);
	this->callStack->setVisible(false);
	
	// Watches Docking Viewer
	this->watches = new QDockWidget(tr("Watches"), this, Qt::Widget);
	this->watches->setAllowedAreas(Qt::BottomDockWidgetArea | Qt::RightDockWidgetArea);
	this->watchesInfoTable = new tablewidget2(this->watches);
	this->watches->setWidget(watchesInfoTable);
	addDockWidget(Qt::RightDockWidgetArea, this->watches);
	this->watches->setVisible(false);
}


/* 
	޴ 
*/
void MainForm::CreateActions()
{
	this->newConnectionAction = new QAction(QIcon("images/newConnect.png"), tr("New Connection"), this);
	this->newConnectionAction->setShortcut(Qt::CTRL + Qt::SHIFT + Qt::Key_N);
	connect(newConnectionAction, SIGNAL(triggered()), this, SLOT(NewConnection()));
	
	this->newQueryTabAction = new QAction(QIcon("images/newQueryTab.png"), tr("New Query Tab"), this);
	this->newQueryTabAction->setShortcut(Qt::CTRL + Qt::Key_N);
	connect(newQueryTabAction, SIGNAL(triggered()), this, SLOT(NewQueryTab()));
	
	this->disconnectAction = new QAction(QIcon("images/disconnect.png"), tr("Disconnect"), this);
	this->disconnectAction->setShortcut(Qt::CTRL + Qt::SHIFT + Qt::Key_X);
	connect(disconnectAction, SIGNAL(triggered()), this, SLOT(Disconnect()));
	
	this->openAction = new QAction(QIcon("images/scriptOpen.png"), tr("&Open"), this);
	this->openAction->setShortcut(Qt::CTRL + Qt::Key_O);
	connect(openAction, SIGNAL(triggered()), this, SLOT(OpenTabWidget()));
	
	this->saveAction = new QAction(QIcon("images/scriptSave.png"), tr("&Save"), this);
	this->saveAction->setShortcut(Qt::CTRL + Qt::Key_S);
	connect(saveAction, SIGNAL(triggered()), this, SLOT(SaveTabWidget()));
	
	this->exitAction = new QAction(tr("E&xit"), this);
	this->exitAction->setShortcut(Qt::ALT + Qt::Key_F4);
	connect(exitAction, SIGNAL(triggered()), this, SLOT(close()));
	
	this->createTableAction = new QAction(tr("Create Table"), this);
	connect(createTableAction, SIGNAL(triggered()), this, SLOT(CreateTable()));
	
	this->alterTableAction = new QAction(tr("Alter Table"), this);
	connect(alterTableAction, SIGNAL(triggered()), this, SLOT(Test()));
	
	this->emptyTableAction = new QAction(tr("Empty Table"), this);
	connect(emptyTableAction, SIGNAL(triggered()), this, SLOT(EmptyTable()));
	
	this->dropTableAction = new QAction(tr("Drop Table"), this);
	connect(dropTableAction, SIGNAL(triggered()), this, SLOT(Test()));
	
	this->viewDataAction = new QAction(QIcon("images/viewTableData.png"), tr("View Data"), this);
	connect(viewDataAction, SIGNAL(triggered()), this, SLOT(DisplayTableData()));
	
	this->exportToXmlAction = new QAction(QIcon("images/exportToXML.png"), tr("Export To XML"), this);
	connect(exportToXmlAction, SIGNAL(triggered()), this, SLOT(ExportToXML()));
	
	this->createStoredProcedureAction = new QAction(tr("Create Stored Procedure"), this);
	connect(createStoredProcedureAction, SIGNAL(triggered()), this, SLOT(CreateStoredProcedure()));

	this->alterStoredProcedureAction = new QAction(tr("Alter Stored Procedure"), this);
	connect(alterStoredProcedureAction, SIGNAL(triggered()), this, SLOT(AlterStoredProcedure()));

	this->dropStoredProcedureAction = new QAction(tr("Drop Stored Procedure"), this);
	connect(dropStoredProcedureAction, SIGNAL(triggered()), this, SLOT(DropStoredProcedure()));

	this->createFunctionAction = new QAction(tr("Create Function"), this);
	connect(createFunctionAction, SIGNAL(triggered()), this, SLOT(CreateFunction()));

	this->alterFunctionAction = new QAction(tr("Alter Function"), this);
	connect(alterFunctionAction, SIGNAL(triggered()), this, SLOT(AlterFunction()));

	this->dropFunctionAction = new QAction(tr("Drop Function"), this);
	connect(dropFunctionAction, SIGNAL(triggered()), this, SLOT(DropFunction()));
	
	this->createViewAction = new QAction(tr("Create View"), this);
	connect(createViewAction, SIGNAL(triggered()), this, SLOT(CreateView()));

	this->alterViewAction = new QAction(tr("Alter View"), this);
	connect(alterViewAction, SIGNAL(triggered()), this, SLOT(AlterView()));

	this->dropViewAction = new QAction(tr("Drop View"), this);
	connect(dropViewAction, SIGNAL(triggered()), this, SLOT(DropView()));

	this->createTriggerAction = new QAction(tr("Create Trigger"), this);
	connect(createTriggerAction, SIGNAL(triggered()), this, SLOT(CreateTrigger()));

	this->alterTriggerAction = new QAction(tr("Alter Trigger"), this);
	connect(alterTriggerAction, SIGNAL(triggered()), this, SLOT(AlterTrigger()));

	this->dropTriggerAction = new QAction(tr("Drop Trigger"), this);
	connect(dropTriggerAction, SIGNAL(triggered()), this, SLOT(DropTrigger()));

	this->refreshTableAction = new QAction(QIcon("images/objectRefresh.png"), tr("Refresh Database View"), this);
	this->refreshTableAction->setShortcut(QKeySequence(Qt::SHIFT + Qt::Key_F5));
	connect(refreshTableAction, SIGNAL(triggered()), this, SLOT(RefreshTable()));

	this->excuteQueryAction = new QAction(QIcon("images/excuteQuery.png"), tr("Excute Query"), this);
	this->excuteQueryAction->setShortcut(QKeySequence(Qt::Key_F5));
	connect(excuteQueryAction, SIGNAL(triggered()), this, SLOT(ExcuteQuery()));

	this->excuteSelectedQueryAction = new QAction(QIcon("images/excuteSelectedQuery.png"), tr("Excute Selected Query"), this);
	this->excuteSelectedQueryAction->setShortcut(QKeySequence(Qt::CTRL + Qt::Key_F5));
	connect(excuteSelectedQueryAction, SIGNAL(triggered()), this, SLOT(ExcuteSelectedQuery()));

	this->breakpointAct = new QAction(QIcon("images/breakpoint.png"),tr("&breakpoint"), this);
	this->breakpointAct->setShortcut(tr("F9"));
	connect(breakpointAct, SIGNAL(triggered()), this->queryTab, SLOT(Slot_SetBreakPointTab()));

	this->allbreakpointcleanAct = new QAction(tr("&All Breakpoint Clean"), this);
	this->allbreakpointcleanAct->setShortcut(tr("Shift+F9"));
	connect(allbreakpointcleanAct, SIGNAL(triggered()), this->queryTab, SLOT(Slot_AllBreakpointCleanTab()));
	
	this->runAct = new QAction(QIcon("images/continue.png"), tr("&Run"), this);
	this->runAct->setShortcut(tr("F7"));
	connect(runAct, SIGNAL(triggered()), this, SLOT(Run()));
	
	this->step_intoAct = new QAction(QIcon("images/step_into.png"), tr("&Step_Into"), this);
	this->step_intoAct->setShortcut(tr("F11"));
	connect(step_intoAct, SIGNAL(triggered()), this, SLOT(StepInto()));

	this->stopAct = new QAction(QIcon("images/stop.png"), tr("&Stop"), this);
	this->stopAct->setShortcut(tr("Shift+F7"));
	connect(this->stopAct, SIGNAL(triggered()), this, SLOT(Stop()));
}

/*
	  
*/
void MainForm::CreateToolbars()
{
	this->fileToolBar = addToolBar(tr("File"));
	this->fileToolBar->addAction(newConnectionAction);
	this->fileToolBar->addAction(newQueryTabAction);
	this->fileToolBar->addAction(disconnectAction);
	this->fileToolBar->addAction(openAction);
	this->fileToolBar->addAction(saveAction);

	this->tableToolBar = addToolBar(tr("Table"));
	this->tableToolBar->addAction(viewDataAction);
	this->tableToolBar->addAction(exportToXmlAction);

	this->queryToolBar = addToolBar(tr("Query"));
	this->queryToolBar->addAction(excuteQueryAction);
	this->queryToolBar->addAction(excuteSelectedQueryAction);
	this->queryToolBar->addAction(refreshTableAction);

	this->debugToolBar = addToolBar(tr("Debug"));
	this->debugToolBar->addAction(breakpointAct);
	this->debugToolBar->addAction(runAct);
	this->debugToolBar->addAction(step_intoAct);
	this->debugToolBar->addAction(stopAct);

	this->debugToolBar->setVisible(false);
}


/* 
	޴ 
*/
void MainForm::CreateMenus()
{
	this->fileMenu = this->menuBar()->addMenu(tr("&File"));
	this->fileMenu->addAction(newConnectionAction);
	this->fileMenu->addAction(newQueryTabAction);
	this->fileMenu->addAction(disconnectAction);
	this->fileMenu->addSeparator();
	this->fileMenu->addAction(openAction);
	this->fileMenu->addAction(saveAction);
	this->fileMenu->addSeparator();
	this->fileMenu->addAction(exitAction);

	this->tableMenu = this->menuBar()->addMenu(tr("&Table"));
	this->tableMenu->addAction(createTableAction);
	this->tableMenu->addAction(alterTableAction);
	this->tableMenu->addAction(emptyTableAction);
	this->tableMenu->addAction(dropTableAction);
	this->tableMenu->addSeparator();
	this->tableMenu->addAction(viewDataAction);
	this->tableMenu->addAction(exportToXmlAction);
	
	QMenu* storedProcedureMenu = new QMenu(tr("Stored Procedure"));

	storedProcedureMenu->addAction(this->createStoredProcedureAction);
	storedProcedureMenu->addAction(this->alterStoredProcedureAction);
	storedProcedureMenu->addAction(this->dropStoredProcedureAction);

	QMenu* functionMenu = new QMenu(tr("Function"));
	
	functionMenu->addAction(this->createFunctionAction);
	functionMenu->addAction(this->alterFunctionAction);
	functionMenu->addAction(this->dropFunctionAction);

	this->queryMenu = this->menuBar()->addMenu(tr("&Query"));
	this->queryMenu->addAction(excuteQueryAction);
	this->queryMenu->addAction(excuteSelectedQueryAction);
	this->queryMenu->addSeparator();
	this->queryMenu->addAction(refreshTableAction);

	QMenu* viewsMenu = new QMenu(tr("View"));

	viewsMenu->addAction(this->createViewAction);
	viewsMenu->addAction(this->alterViewAction);
	viewsMenu->addAction(this->dropViewAction);

	QMenu* triggerMenu = new QMenu(tr("Trigger"));

	triggerMenu->addAction(this->createTriggerAction);
	triggerMenu->addAction(this->alterTriggerAction);
	triggerMenu->addAction(this->dropTriggerAction);

	this->objectMenu = this->menuBar()->addMenu(tr("&Object"));
	this->objectMenu->addMenu(storedProcedureMenu);
	this->objectMenu->addMenu(functionMenu);
	this->objectMenu->addMenu(viewsMenu);
	this->objectMenu->addMenu(triggerMenu);

	this->viewMenu = this->menuBar()->addMenu(tr("&View"));
	this->viewMenu->addAction(dock->toggleViewAction());
	
	// kang
	this->viewMenu->addAction(codeTemplateDock->toggleViewAction());
	this->viewMenu->addAction(breakPointerInfo->toggleViewAction());
	this->viewMenu->addAction(callStack->toggleViewAction());
	this->viewMenu->addAction(watches->toggleViewAction());

	this->debugMenu = this->menuBar()->addMenu(tr("&Debug"));
	this->debugMenu->addAction(breakpointAct);
	this->debugMenu->addAction(allbreakpointcleanAct);
	this->debugMenu->addAction(runAct);
	this->debugMenu->addAction(stopAct);
}


/* 
	  
*/
void MainForm::CreateStatusBar()
{
	this->statusBar()->showMessage(tr("Ready"));
}


/* 
	ȭ 
*/
void MainForm::SetLayout()
{
	this->debuggingMode = 0;
	this->horizontalSplitter = new QSplitter(Qt::Horizontal, this->dock);
	this->verticalSplitter = new QSplitter(Qt::Vertical, this->horizontalSplitter);
	
	setCentralWidget(this->verticalSplitter);
	
	this->verticalSplitter->addWidget(this->queryTab);
	this->verticalSplitter->addWidget(this->resultTab);

	this->showMaximized();
}

/* 
	̺ ͸ 
*/
void MainForm::DisplayTableData()
{
	int ret = CheckCurrentItemIsTable();
	
	if( ret == 1){

		QString table = this->folderView->currentItem()->text(0);
		
		this->resultTab->setCurrentIndex(2);

		this->tableModel = new QSqlTableModel();
		this->tableModel->setTable(table);
		this->tableModel->setEditStrategy(QSqlTableModel::OnManualSubmit);
		this->tableModel->select();
		
		QSqlError error;
		QSqlQuery query("desc " + table);
		
		error = query.lastError();
		
		// ̺  ִ κ
		if (error.text() == " "){
			int i=0;
			
			i = 0;

			query = "select * from " + table;

			while(query.next()){
				i++;
			}

			QTableView *view = ((TableData*)(this->resultTab->currentWidget()))->GetTableView();

			view->setModel(this->tableModel);
			view->show();

			QString buffer;
			
			QTextStream(&buffer) << i <<" row(s) affected";
			
			((QTextEdit*)(this->resultTab->widget(1)))->setText(buffer);
		}
		
		//  ޽ ϴ κ
		else{
			this->resultTab->setCurrentIndex(1);
			((QTextEdit*)(this->resultTab->widget(1)))->setText(error.text());
		}
	}
}


/*
	ڵ ø 
*/
void MainForm::DisplayCodeTemplate()
{
	QTreeWidgetItem* childItem = this->codeTemplate->currentItem()->child(0);
	QString itemName = this->codeTemplate->currentItem()->text(0);
	QString sql;

	if(childItem == 0){
		sql = this->codeTemplate->FindCodeTemplate(itemName);
		((MainTextEdit*)(this->queryTab->currentWidget()))->GetTextEdit()->append(sql);
	}
}

/* 
	ν  
*/
void MainForm::CreateStoredProcedure()
{
	this->name.clear();
	this->CreateDialog();
	
	if( this->name != 0){

		qDebug() << "aa";
		MainTextEdit* mainTextEdit = new MainTextEdit();
		new Highlighter(mainTextEdit->GetTextEdit()->document());

		//this->addTab(mainTextEdit, QIcon("images/query.png"), tr("Query"));
		//QTextEdit* textEdit = new QTextEdit();
		//new Highlighter(textEdit->document());

		this->queryTab->addTab(mainTextEdit, QIcon("images/test.png"), this->name);
		this->queryTab->setCurrentIndex(this->queryTab->count()-1);
		
		QString sql("DROP PROCEDURE IF EXISTS `" + (ConnectionForm::getInstance()->GetDb()->databaseName()) + "`. `" 
			+ this->name+"` ;\n\nCREATE PROCEDURE `" + (ConnectionForm::getInstance()->GetDb()->databaseName()) + "`. `" + this->name + 
			"`() \n  \t/*LANGUAGE SQL \n\t| [NOT] DETERMINISTIC \n\t| { CONTAINS SQL | NO SQL | READS SQL DATA qq| MODIFIES SQL DATA } \n\t| SQL SECURITY { DEFINER | INVOKER } \n\t| COMMENT 'string'*/\n\tBEGIN\n\n\tEND;");
		
		qDebug() << "bb";
		((MainTextEdit*)(this->queryTab->currentWidget()))->GetTextEdit()->setText(sql);
		qDebug() << "cc";
	}
}

/*
	ο ̸ Dialog 
*/
void MainForm::CreateDialog()
{
	this->newName = new QDialog(this);
	this->newName->setWindowTitle("newName");
	this->newName->resize(200, 100);
	
	QLineEdit* nameEdit = new QLineEdit(this->newName);
	nameEdit->setGeometry(QRect(10, 20, 180, 30));
	nameEdit->setWindowTitle("nameEdit");
	
	QPushButton* nameOkButton = new QPushButton(this->newName);
	nameOkButton->setGeometry(QRect(50, 60, 65, 27));
	nameOkButton->setWindowTitle("nameOkButton");
	nameOkButton->setText("OK");
	
	QPushButton* nameCancelButton = new QPushButton(this->newName);
	nameCancelButton->setGeometry(QRect(125, 60, 65, 27));
	nameCancelButton->setWindowTitle("nameCancelButton");
	nameCancelButton->setText("Cancel");
	
	connect(nameOkButton, SIGNAL(clicked()), this, SLOT(SetName()));
	connect(nameCancelButton, SIGNAL(clicked()), this->newName, SLOT(close()));
	
	this->newName->exec();
}

/* 
	̸  
*/
void MainForm::SetName()
{
	QWidget* name = this->newName->childAt(10, 20);
	QString title(((QLineEdit*)name)->text());
	
	this->name = title;
	
	this->newName->close(); 
}


/* 
	̺ 
*/
void MainForm::DropTable()
{
	QString table = this->folderView->currentItem()->text(0);
	
	int messageRet = QMessageBox::warning(this, "Delete Table", 
		tr("ðڽϱ?"), QMessageBox::Ok | QMessageBox::Cancel);
	
	if( messageRet == QMessageBox::Ok){
		
		this->resultTab->setCurrentIndex(1);
		
		QSqlError error;
		QSqlQuery query("drop table "+table);
		
		error = query.lastError();
		
		// ̺  ִ κ
		if (error.text() == " "){
			int i=0;
			
			while (query.next()) {
				i++;
			}
			
			QString buffer;
			QTextStream(&buffer) << i <<" row(s) affected";
			
			((QTextEdit*)(this->resultTab->widget(1)))->setText(buffer);
		}
		
		//  ޽ ϴ κ
		else{
			((QTextEdit*)(this->resultTab->widget(1)))->setText(error.text());
		}
	}
}

/* 
	̺   
*/
void MainForm ::EmptyTable()
{
	QString table = this->folderView->currentItem()->text(0);

	this->resultTab->setCurrentIndex(1);
	
	QSqlError error;
	QSqlQuery query("truncate table "+ table);
	
	error = query.lastError();
	
	// ̺  ִ κ
	if (error.text() == " "){
		int i=0;
		
		while (query.next()) {
			i++;
		}
		
		QString buffer;
		QTextStream(&buffer) << i <<" row(s) affected";
		
		((QTextEdit*)(this->resultTab->widget(1)))->setText(buffer);
	}
	
	//  ޽ ϴ κ
	else{
		((QTextEdit*)(this->resultTab->widget(1)))->setText(error.text());
	}
}

/* 
̺ ̸ 
*/
void MainForm::RenameTable()
{
	QString table = this->folderView->currentItem()->text(0);
	this->name.clear();
	this->CreateDialog();
	
	if( this->name != 0){
		
		this->resultTab->setCurrentIndex(1);
		
		QSqlError error;
		QSqlQuery query("rename table "+ table +  " to " + this->name);
		
		error = query.lastError();
		
		// ̺  ִ κ
		if (error.text() == " "){
			
			int i=0;
			
			while (query.next()) {
				i++;
			}
			
			QString buffer;
			QTextStream(&buffer) << i <<" row(s) affected";
			
			((QTextEdit*)(this->resultTab->widget(1)))->setText(buffer);
			
			this->folderView->clear();
			this->folderView->MakeTreeView();
		}
		
		//  ޽ ϴ κ
		else{
			((QTextEdit*)(this->resultTab->widget(1)))->setText(error.text());
		}
	}
}


/* 
	Į 
*/
void MainForm::ManageColumn()
{
}


/* 
	ν 
*/
void MainForm::AlterStoredProcedure()
{
	//this->debuggingMode = 1;

	QString procedure = this->folderView->currentItem()->text(0);

	QSqlError error;
	QSqlQuery query("SHOW CREATE PROCEDURE "+ procedure);
	
	error = query.lastError();
	
	// ̺  ִ κ
	if (error.text() == " "){

		MainTextEdit* mainTextEdit = new MainTextEdit();
		new Highlighter(mainTextEdit->GetTextEdit()->document());
		
		this->queryTab->addTab(mainTextEdit, QIcon("images/test.png"), procedure);
		this->queryTab->setCurrentIndex(this->queryTab->count() - 1);
		
		int i=0;
		QString sql;
		
		while (query.next()) {
			sql = query.value(2).toString();
			i++;
		}
		
		QString text("DROP PROCEDURE IF EXISTS `" +  (ConnectionForm::getInstance()->GetDb()->databaseName()) + 
			"`.`" + procedure + "`;\n\n" + sql);
		
		((MainTextEdit*)(this->queryTab->currentWidget()))->GetTextEdit()->setText(text);
		
		QString buffer;
		QTextStream(&buffer) << i <<" row(s) affected";
		((QTextEdit*)(this->resultTab->widget(1)))->setText(buffer);	
	}
	
	//  ޽ ϴ κ
	else{
		((QTextEdit*)(this->resultTab->widget(1)))->setText(error.text());
	}
}

/* 
	ν 
*/
void MainForm::DropStoredProcedure()
{
	QString procedure = this->folderView->currentItem()->text(0);

	int messageRet = QMessageBox::warning(this, "Delete Procedure", 
		tr("ðڽϱ?"), QMessageBox::Ok | QMessageBox::Cancel);
	
	if( messageRet == QMessageBox::Ok){
		
		this->resultTab->setCurrentIndex(1);
		
		QSqlError error;
		QSqlQuery query("drop procedure " + procedure);
		
		error = query.lastError();
		
		// ̺  ִ κ
		if (error.text() == " "){
			int i=0;
			
			while (query.next()) {
				i++;
			}
			
			QString buffer;
			QTextStream(&buffer) << i <<" row(s) affected";
			
			((QTextEdit*)(this->resultTab->widget(1)))->setText(buffer);
			
			this->folderView->clear();
			this->folderView->MakeTreeView();
		}
		
		//  ޽ ϴ κ
		else{
			((QTextEdit*)(this->resultTab->widget(1)))->setText(error.text());
		}
	}
}


/* 
	Լ  
*/
void MainForm::CreateFunction()
{
	this->name.clear();
	this->CreateDialog();
	
	if( this->name != 0){

		MainTextEdit* mainTextEdit = new MainTextEdit();
		new Highlighter(mainTextEdit->GetTextEdit()->document());
		
		this->queryTab->addTab(mainTextEdit, QIcon("images/test.png"), this->name);
		this->queryTab->setCurrentIndex(this->queryTab->count()-1);
		
		QString sql("DROP FUNCTION IF EXISTS `" 
			+ this->name+"` ;\n\nCREATE FUNCTION `" + this->name + 
			"`() \n \t\tRETURNS type\n \t/*LANGUAGE SQL \n\t| [NOT] DETERMINISTIC \n\t| { CONTAINS SQL | NO SQL | READS SQL DATA qq| MODIFIES SQL DATA } \n\t| SQL SECURITY { DEFINER | INVOKER } \n\t| COMMENT 'string'*/\n\tBEGIN\n\n\tEND;");
		
		((MainTextEdit*)(this->queryTab->currentWidget()))->GetTextEdit()->setText(sql);
	}
}

/* 
	Լ 
*/
void MainForm::AlterFunction()
{
	QString function = this->folderView->currentItem()->text(0);

	QSqlError error;
	QSqlQuery query("SHOW CREATE FUNCTION "+ function);
	
	error = query.lastError();
	
	// ̺  ִ κ
	if (error.text() == " "){

		MainTextEdit* mainTextEdit = new MainTextEdit();
		new Highlighter(mainTextEdit->GetTextEdit()->document());
		
		this->queryTab->addTab(mainTextEdit, QIcon("images/test.png"), function);
		this->queryTab->setCurrentIndex(this->queryTab->count() - 1);
		
		int i=0;
		QString sql;
		
		while (query.next()) {
			sql = query.value(2).toString();
			i++;
		}
		
		QString text("DROP FUNCTION IF EXISTS `" +  (ConnectionForm::getInstance()->GetDb()->databaseName()) + 
			"`.`" + function + "`;\n\n" + sql + "\n\n\t");
		((MainTextEdit*)(this->queryTab->currentWidget()))->GetTextEdit()->setText(text);
		
		QString buffer;
		QTextStream(&buffer) << i <<" row(s) affected";
		((QTextEdit*)(this->resultTab->widget(1)))->setText(buffer);		
	}
	
	//  ޽ ϴ κ
	else{
		((QTextEdit*)(this->resultTab->widget(1)))->setText(error.text());
	}
}

/* 
	Լ  
*/
void MainForm::DropFunction()
{
	QString function = this->folderView->currentItem()->text(0);

	int messageRet = QMessageBox::warning(this, "Delete Function", 	tr("ðڽϱ?"), QMessageBox::Ok | QMessageBox::Cancel);
	
	if( messageRet == QMessageBox::Ok){
		
		this->resultTab->setCurrentIndex(1);
		
		QSqlError error;
		QSqlQuery query("drop function " + function);
		
		error = query.lastError();
		
		// ̺  ִ κ
		if (error.text() == " "){
			int i=0;
			
			while (query.next()) {
				i++;
			}
			
			QString buffer;
			QTextStream(&buffer) << i <<" row(s) affected";
			
			((QTextEdit*)(this->resultTab->widget(1)))->setText(buffer);
			
			this->folderView->clear();
			this->folderView->MakeTreeView();
		}
		
		//  ޽ ϴ κ
		else{
			((QTextEdit*)(this->resultTab->widget(1)))->setText(error.text());
		}
	}
}

/* 
	  
*/
void MainForm::CreateView()
{
	this->name.clear();
	this->CreateDialog();
	
	if( this->name != 0){

		MainTextEdit* mainTextEdit = new MainTextEdit();
		new Highlighter(mainTextEdit->GetTextEdit()->document());
		
		this->queryTab->addTab(mainTextEdit, QIcon("images/test.png"), this->name);
		this->queryTab->setCurrentIndex(this->queryTab->count() - 1);
		
		QString sql("DROP VIEW IF EXISTS `" + (ConnectionForm::getInstance()->GetDb()->databaseName()) + "`.`" + this->name+
			"`;\n\nCREATE\n\t/*[ALGORITHM = {UNDEFINED | MERGE | TEMPTABLE}]\n\t[DEFINER = { user | CURRENT_USER }]\n\t" +
			"[SQL SECURITY { DEFINER | INVOKER }]*/\n\tVIEW `"+ (ConnectionForm::getInstance()->GetDb()->databaseName()) + "`.`" + this->name +
			"`\n\t\tAS\n\t\t\t(SELECT * FROM ...)");
		
		((MainTextEdit*)(this->queryTab->currentWidget()))->GetTextEdit()->setText(sql);
	}
}

/* 
	  
*/
void MainForm::AlterView()
{
	QString view = this->folderView->currentItem()->text(0);

	QSqlError error;
	QSqlQuery query("SHOW CREATE VIEW "+ view);
	
	error = query.lastError();
	
	// ̺  ִ κ
	if (error.text() == " "){

		MainTextEdit* mainTextEdit = new MainTextEdit();
		new Highlighter(mainTextEdit->GetTextEdit()->document());
		
		this->queryTab->addTab(mainTextEdit, QIcon("images/test.png"), view);
		this->queryTab->setCurrentIndex(this->queryTab->count() - 1);
		
		int i=0;
		QString sql;
		
		while (query.next()) {
			sql = query.value(1).toString();
			i++;
		}
		
		QString text("DROP VIEW IF EXISTS `" +  (ConnectionForm::getInstance()->GetDb()->databaseName()) + 
			"`.`" + view + "`;\n\n" + sql + ";");
		
		((MainTextEdit*)(this->queryTab->currentWidget()))->GetTextEdit()->setText(text);
		
		QString buffer;
		QTextStream(&buffer) << i <<" row(s) affected";
		((QTextEdit*)(this->resultTab->widget(1)))->setText(buffer);	
	}
	
	//  ޽ ϴ κ
	else{
		((QTextEdit*)(this->resultTab->widget(1)))->setText(error.text());
	}
}

/* 
	  
*/
void MainForm::DropView()
{
	QString view = this->folderView->currentItem()->text(0);

	int messageRet = QMessageBox::warning(this, "Delete View", 	tr("ðڽϱ?"), QMessageBox::Ok | QMessageBox::Cancel);
	
	if( messageRet == QMessageBox::Ok){
		
		this->resultTab->setCurrentIndex(1);
		
		QSqlError error;
		QSqlQuery query("drop view " + view);
		
		error = query.lastError();
		
		// ̺  ִ κ
		if (error.text() == " "){
			int i=0;
			
			while(query.next()){
				i++;
			}
			
			QString buffer;
			QTextStream(&buffer) << i <<" row(s) affected";
			
			((QTextEdit*)(this->resultTab->widget(1)))->setText(buffer);
			
			this->folderView->clear();
			this->folderView->MakeTreeView();
		}
		
		//  ޽ ϴ κ
		else{
			((QTextEdit*)(this->resultTab->widget(1)))->setText(error.text());
		}
	}
}

/* 
	 Rename 
*/
void MainForm::RenameView()
{
	QString view = this->folderView->currentItem()->text(0);

	this->name.clear();
	this->CreateDialog();
	
	if( this->name != 0){
		
		this->resultTab->setCurrentIndex(1);
		
		QSqlError error;
		QSqlQuery query("rename table "+ view +  " to " + this->name);
		
		error = query.lastError();
		
		// ̺  ִ κ
		if (error.text() == " "){
			
			int i=0;
			
			while (query.next()) {
				i++;
			}
			
			QString buffer;
			QTextStream(&buffer) << i <<" row(s) affected";
			
			((QTextEdit*)(this->resultTab->widget(1)))->setText(buffer);
			
			this->folderView->clear();
			this->folderView->MakeTreeView();
		}
		
		//  ޽ ϴ κ
		else{
			((QTextEdit*)(this->resultTab->widget(1)))->setText(error.text());
		}
	}
}

/*
	Ʈ  
*/
void MainForm::CreateTrigger()
{
	this->name.clear();
	this->CreateDialog();
	
	if( this->name != 0){

		MainTextEdit* mainTextEdit = new MainTextEdit();
		new Highlighter(mainTextEdit->GetTextEdit()->document());
		
		this->queryTab->addTab(mainTextEdit, QIcon("images/test.png"), this->name);
		this->queryTab->setCurrentIndex(this->queryTab->count() - 1);
		
		QString sql("DROP TRIGGER  /* !50032 IF EXISTS  */   `" + (ConnectionForm::getInstance()->GetDb()->databaseName()) + "`.`" + this->name +
			"`;\n\nCREATE TRIGGER " + this->name + " BEFORE/AFTER INSERT/UPDATE/DELETE on TABLENAME \nFOR EACH ROW BEGIN\n\nEND"); 
		
		((MainTextEdit*)(this->queryTab->currentWidget()))->GetTextEdit()->setText(sql);
	}
}

/*
	Ʈ  
*/
void MainForm::AlterTrigger()
{
	QString trigger = this->folderView->currentItem()->text(0);

	QSqlError error;
	QSqlQuery query("SELECT TRIGGER_SCHEMA, TRIGGER_NAME, EVENT_MANIPULATION, EVENT_OBJECT_TABLE, ACTION_TIMING,  ACTION_STATEMENT FROM INFORMATION_SCHEMA.TRIGGERS WHERE TRIGGER_NAME= '" + trigger +"'");
	
	error = query.lastError();
	
	// ̺  ִ κ
	if (error.text() == " "){
		
		int i=0;
		QString db;
		QString triggerName;
		QString event;
		QString tableName;
		QString actionTiming;
		QString statement;

		
		
		while (query.next()) {			
			db = query.value(0).toString();
			triggerName = query.value(1).toString();
			event = query.value(2).toString();
			tableName = query.value(3).toString();
			actionTiming = query.value(4).toString();
			statement = query.value(5).toString();
			i++;
		}

		if( (ConnectionForm::getInstance()->GetDb()->databaseName()) == db ){
			QString text("DROP TRIGGER IF EXISTS `" +  (ConnectionForm::getInstance()->GetDb()->databaseName()) + 
				"`.`" + trigger + "`;\n\nCREATE TRIGGER `" + triggerName + "` " + actionTiming + " " + event
				+ " ON " + tableName + "\nFOR EACH ROW\n" + statement + " ;");
			
			QTextEdit* textEdit = new QTextEdit();
			new Highlighter(textEdit->document());

			this->queryTab->addTab(textEdit, QIcon("images/test.png"), trigger);
			this->queryTab->setCurrentIndex(this->queryTab->count() - 1);
			((MainTextEdit*)(this->queryTab->currentWidget()))->GetTextEdit()->setText(text);
		}
		
		QString buffer;
		QTextStream(&buffer) << i <<" row(s) affected";
		((QTextEdit*)(this->resultTab->widget(1)))->setText(buffer);
	}
	
	//  ޽ ϴ κ
	else{
		((QTextEdit*)(this->resultTab->widget(1)))->setText(error.text());
	}
}

/* 
	Ʈ  
*/
void MainForm::DropTrigger()
{
	QString trigger = this->folderView->currentItem()->text(0);

	int messageRet = QMessageBox::warning(this, "Delete View", 	tr("ðڽϱ?"), QMessageBox::Ok | QMessageBox::Cancel);
	
	if( messageRet == QMessageBox::Ok){
		
		this->resultTab->setCurrentIndex(1);
		
		QSqlError error;
		QSqlQuery query("drop trigger " + trigger);
		
		error = query.lastError();
		
		// ̺  ִ κ
		if (error.text() == " "){
			int i=0;
			
			while (query.next()) {
				i++;
			}
			
			QString buffer;
			QTextStream(&buffer) << i <<" row(s) affected";
			
			((QTextEdit*)(this->resultTab->widget(1)))->setText(buffer);
			
			this->folderView->clear();
			this->folderView->MakeTreeView();
		}
		
		//  ޽ ϴ κ
		else{
			((QTextEdit*)(this->resultTab->widget(1)))->setText(error.text());
		}
	}
}


/* 
	ExportToXML ñ׳ ߻ 
*/
void MainForm::ExportToXML()
{
	QString fileName = QFileDialog::getSaveFileName(this, tr("Export To XML"), "untitled", 
									tr("XML (*.xml)"));
	fileName = fileName + ".xml";
    if (!fileName.isEmpty()){
		ExportToXMLFile(fileName);
	}
}


/* 
	XML Ϸ 
*/
void MainForm::ExportToXMLFile(QString& fileName)
{
	QFile file(fileName);
    if(!file.open(QFile::WriteOnly | QFile::Text)){
        QMessageBox::warning(this, tr("Application"), tr("Cannot Export To File %1:\n%2.")
			.arg(fileName).arg(file.errorString()));
    }

	else{
		QString tableName = this->folderView->currentItem()->text(0);
		QSqlQuery sql("desc " + tableName);
		
		QSqlError error = sql.lastError();
		QStringList columnList;					// Column 
		QString xml;							// µ XML

		if (error.text() == " "){
			
			QSqlQuery query("select * from " + tableName);

			while(sql.next()){
				columnList << sql.value(0).toString();
			}

			int count = 0;
			int length = columnList.count();

			xml.append("<data>\n");

			while (query.next()) {
				xml.append("\t<row>\n");

				for(int i=0; i<length; i++){
					xml.append("\t\t<"+columnList[i%length]+">");
					xml.append(query.value(i).toString());
					xml.append("</"+columnList[i%length]+">\n");
				}

				xml.append("\t</row>\n\n");
				count++;
			}

			xml.append("</data>\n");
		}

		QTextStream out(&file);
		QApplication::setOverrideCursor(Qt::WaitCursor);
		out << xml;
		QApplication::restoreOverrideCursor();
	}
}


/* 
	 Ʈ   ̺ üũ
*/
int MainForm::CheckCurrentItemIsTable()
{
	int ret = 0;
	
	if(folderView->currentItem() != 0 ){
		
		QString itemName = folderView->currentItem()->text(0);
		QString parentName;
		
		if( this->folderView->currentItem()->parent() != 0){
			parentName = this->folderView->currentItem()->parent()->text(0);
		}
		
		if( itemName == "Stored Procs" || parentName =="Stored Procs"){
		}

		else if( itemName == "Tables" ){
		}
		
		else if ( itemName == "Functions" || parentName =="Functions"){
		}
		
		else if( itemName == "Columns" || parentName == "Columns"){
		}
		
		else if( itemName == "Indexes" || parentName == "Indexes"){
		}
		
		else if( itemName == "Views"){
		}
		
		else if( itemName == "Triggers" || parentName == "Triggers"){
		}
		else if( itemName == ((ConnectionForm*)(this->parent()))->GetDb()->databaseName() ){
		}
		
		else{
			ret = 1;
		}
	}
	
	return ret;
}


/* 
	â ݴ ̺Ʈ ߻ 
*/
void MainForm::closeEvent ( QCloseEvent * event )
{
	((ConnectionForm*)(this->parent()))->close();
}


/* 
	޴  ñ׳ ߻ óǴ 
*/
void MainForm::SaveTabWidget()
{
	this->queryTab->Save();
}


/* 
	޴  ñ׳ ߻ óǴ 
*/
void MainForm::OpenTabWidget()
{
	this->queryTab->Open();
}


/* 
	޴ ο   
*/
void MainForm:: NewQueryTab()
{
	QTextEdit* textEdit = new QTextEdit();
	new Highlighter(textEdit->document());
	
	this->queryTab->addTab(textEdit, QIcon("images/test.png"), "untitle");
	this->queryTab->setCurrentIndex(this->queryTab->count()-1);
}


/* 
	ο 
*/
void MainForm::NewConnection()
{
	((ConnectionForm*)(this->parent()))->SetStateOfReconnect(true);
	((ConnectionForm*)(this->parent()))->setVisible(true);
	this->setEnabled(false);
}


/* 
	ο ӿ  ȭ 籸
*/
void MainForm::NewSetting()
{
	this->folderView->clear();
	this->folderView->setHeaderLabel("");
	this->folderView->MakeTreeView();
	
    this->codeTemplate->clear();
	this->codeTemplate->setHeaderLabel("");
	this->codeTemplate->MakeTreeView();

	this->setEnabled(true);
}

/* 
	 ̽ Ʈ Refresh
*/
void MainForm::RefreshTable()
{
	this->folderView->clear();
	this->folderView->MakeTreeView();
}


/* 
	 
*/
void MainForm::ExcuteQuery()
{
	TextEdit* textEdit = ((MainTextEdit*)(this->queryTab->currentWidget()))->GetTextEdit();
	//QTextEdit* textEdit = ((QTextEdit*)(this->queryTab->currentWidget()));
	QString buffer;
	
	buffer = textEdit->toPlainText();
	
	QSqlError error;
	QSqlQuery query(buffer);
	
	error = query.lastError();
	
	// ̺  ִ κ
	if (error.text() == " "){
		
		QStringList list = buffer.split(" ");
		
		if( list[0].toLower()  == "show" ||list[0].toLower()  == "select" ){
			
			QSqlQueryModel *model = new QSqlQueryModel();
			model->setQuery(query);
			
			int i=0;
			
			while (query.next()) {
				model->setHeaderData(i++, Qt::Horizontal, query.value(0).toString());
			}
			
			this->resultTab->setCurrentIndex(0);
			((QTableView*)(this->resultTab->currentWidget()))->setModel(model);
			((QTableView*)(this->resultTab->currentWidget()))->show();
			
			QString buffer;
			QTextStream(&buffer) << i <<" row(s) affected";
			((QTextEdit*)(this->resultTab->widget(1)))->setText(buffer);
		}
		
		else {
			int i = 0;
			
			while (query.next()) {
				i++;
			}
			
			QString buffer;
			QTextStream(&buffer) << i <<" row(s) affected";
			this->resultTab->setCurrentIndex(1);
			((QTextEdit*)(this->resultTab->widget(1)))->setText(buffer);
		}
	}
	
	//  ޽ ϴ κ
	else{
		this->resultTab->setCurrentIndex(1);
		((QTextEdit*)(this->resultTab->widget(1)))->setText(error.text());
	}
}

/* 
  
*/
void MainForm::ExcuteSelectedQuery()
{
	TextEdit* textEdit = ((MainTextEdit*)(this->queryTab->currentWidget()))->GetTextEdit();
	QString buffer1;
	
	buffer1 = textEdit->textCursor().selectedText();
	QString buffer = buffer1.fromUtf8(buffer1.toStdString().c_str());
	buffer.replace(QChar('?'), QChar(' '));

	QSqlError error;
	QSqlQuery query(buffer);
	
	error = query.lastError();
	
	// ̺  ִ κ
	if (error.text() == " "){
		
		QStringList list = buffer.split(" ");
		
		if( list[0].toLower()  == "show" || list[0].toLower()  == "select" ){
			
			QSqlQueryModel *model = new QSqlQueryModel();
			model->setQuery(query);
			
			int i=0;
			
			while (query.next()) {
				model->setHeaderData(i++, Qt::Horizontal, query.value(0).toString());
			}
			
			this->resultTab->setCurrentIndex(0);
			((QTableView*)(this->resultTab->currentWidget()))->setModel(model);
			((QTableView*)(this->resultTab->currentWidget()))->show();
			
			QString buffer;
			QTextStream(&buffer) << i <<" row(s) affected";
			((QTextEdit*)(this->resultTab->widget(1)))->setText(buffer);
		}
		
		else {
			int i = 0;
			
			while (query.next()) {
				i++;
			}
			
			QString buffer;
			QTextStream(&buffer) << i <<" row(s) affected";
			this->resultTab->setCurrentIndex(1);
			((QTextEdit*)(this->resultTab->widget(1)))->setText(buffer);
		}
	}
	
	//  ޽ ϴ κ
	else{
		this->resultTab->setCurrentIndex(1);
		((QTextEdit*)(this->resultTab->widget(1)))->setText(error.text());
	}
}


/* 
	  
*/
void MainForm::Disconnect()
{
	if( ConnectionForm::getInstance()->GetDb() != 0 ){
		ConnectionForm::getInstance()->GetDb()->close();
	}

	this->folderView->clear();
	this->codeTemplate->clear();

	((QTableView*)(this->resultTab->widget(0)))->setModel(new QSqlTableModel());
	((QTextEdit*)(this->resultTab->widget(1)))->clear();
	((TableData*)(this->resultTab->widget(2)))->GetTableView()->setModel(new QSqlTableModel());

	for( int i=this->queryTab->count(); i>0; i--){
		this->queryTab->removeTab(i);
	}

	((MainTextEdit*)(this->queryTab->widget(0)))->GetTextEdit()->clear();
}


/* 
	̺ 𵨿  ߰
*/
void MainForm::InsertRowInTableModel()
{
	int row = this->tableModel->rowCount();
	this->tableModel->insertRows(row , 1);
	
	QTableView *view = ((TableData*)(this->resultTab->currentWidget()))->GetTableView();
	view->setModel(this->tableModel);
	view->show();
}


void MainForm::DeleteRowInTableModel()
{
 QTableView *view = ((TableData*)(this->resultTab->currentWidget()))->GetTableView();
 QModelIndex index = view->currentIndex();
 qDebug() << this->tableModel->removeRows(index.row(),1);

 view->setRowHidden(index.row(), true) ;
 
 view->setModel(this->tableModel);
 view->show();
}

void MainForm::CreateDatabase()
{
	this->name.clear();
	this->CreateDialog();
	
	if( this->name != 0){

		QString sql("CREATE DATABASE `" + this->name + "`");
		QSqlQuery query(sql);
		QSqlError error = query.lastError();
		
		if(error.text() == " "){
			int i = 0;
			
			while (query.next()) {
				i++;
			}
			
			QString buffer;
			QTextStream(&buffer) << i <<" row(s) affected";
			this->resultTab->setCurrentIndex(1);
			((QTextEdit*)(this->resultTab->widget(1)))->setText(buffer);
		}
		
		else{
			this->resultTab->setCurrentIndex(1);
			((QTextEdit*)(this->resultTab->widget(1)))->setText(error.text());
		}
	}
}

void MainForm::DropDatabase()
{
	QSqlDatabase* db = ((ConnectionForm*)(this->parent()))->GetDb();

	int messageRet = QMessageBox::warning(this, "Drop Database", 
		"Do you really want to drop the '" + db->databaseName() + "'", QMessageBox::Ok | QMessageBox::Cancel);
	
	if( messageRet == QMessageBox::Ok){
		QString sql("DROP DATABASE `" + this->name + "`");
		QSqlQuery query(sql);
		QSqlError error = query.lastError();
		
		if(error.text() == " "){
			int i = 0;
			
			while (query.next()) {
				i++;
			}
			
			QString buffer;
			QTextStream(&buffer) << i <<" row(s) affected";
			this->resultTab->setCurrentIndex(1);
			((QTextEdit*)(this->resultTab->widget(1)))->setText(buffer);
		
			this->Disconnect();

		}
		
		else{
			this->resultTab->setCurrentIndex(1);
			((QTextEdit*)(this->resultTab->widget(1)))->setText(error.text());
		}
	}
}

/* 
	 ̺ ͸  ̽ 
*/
void MainForm::ExcuteTableData()
{	
	this->tableModel->submitAll();
}

/* 
 
*/
void MainForm::Run()
{
	this->debugToolBar->setVisible(true);
	numberReturn = 0;

	listvalue.clear();		// QList Ľ ν  
	listvalue1.clear();		// QList ν  
	listvalue2.clear();		// QList ν  
	listvalue3.clear();		// QList ν    

	// DB QueryTab  Tab Procedure ̸ .
	ConnectionForm* connectionForm = ConnectionForm::getInstance();	
	QSqlDatabase* db = connectionForm->GetDb();	
	QString dbName = db->databaseName();
	int queryTabIndex = this->queryTab->currentIndex();
	QString procedureName = this->queryTab->tabText(queryTabIndex);
	//  ؽƮ  buffer 
	TextEdit* textEdit = (((MainTextEdit*)(this->queryTab->currentWidget())))->GetTextEdit();
	QString buffer = textEdit->toPlainText();
	
	// ν    ƾ 
	QString mp3Str;
	int mode = 0;
	int state = 0;
	for( int i=0; i < buffer.count(); i++)
	{
		if(buffer[i] == ')'){
			mode = 2;
			state--;
		}
		
		if( mode == 2 && state == 0 )
			break;
		
		if( (mode == 1) || (mode == 2 || state != 0)){
			mp3Str.append(buffer[i]);
		}
		
		if( buffer[i] == '('){
			mode = 1;
			state++;
		}
	}
	mp3Str.simplified(); // ĭ 

	QStringList mp3StrList = mp3Str.split(",");
	QStringList mp3StrList1;

	for(int i=0; i < mp3StrList.count(); i++)
	{
		mp3StrList1 << mp3StrList[i].split(" ", QString::SkipEmptyParts);
	}
	
	QStringList mp3StrList2;
	for(int i=0; i < mp3StrList1.count(); i++)
	{
		mp3StrList2 << mp3StrList1[i].split("(", QString::SkipEmptyParts);
	}
	
	QStringList mp3StrList3;
	for(int i=0; i < mp3StrList2.count(); i++)
	{
		mp3StrList3 << mp3StrList2[i].split(")", QString::SkipEmptyParts);
	}
	
	for(int i = 0; i < mp3StrList3.count(); i++)
	{
		if((mp3StrList3[i] == "INT") || (mp3StrList3[i] == "int") || (mp3StrList3[i] == "Int") 
			|| (mp3StrList3[i] == "CHAR") || (mp3StrList3[i] == "char") || (mp3StrList3[i] == "Char") 
			|| (mp3StrList3[i] == "VARCHAR") || (mp3StrList3[i] == "varchar") || (mp3StrList3[i] == "Varchar") 
			||(mp3StrList3[i] == "FLOAT") || (mp3StrList3[i] == "Float") || (mp3StrList3[i] == "float"))
		{
			listvalue1 << mp3StrList3[i-1];
			listvalue3 << mp3StrList3[i-1];	
		}
	}

	// ν   ƾ
	listvalue = buffer.split(QRegExp("\\s+"));

	for(int i = 0; i < listvalue.count(); i++)	
	{
		if((listvalue[i] == "DECLARE") || (listvalue[i] == "declare") || (listvalue[i] == "Declare"))
		{
			
			listvalue2 << listvalue[i+1];
			listvalue3 << listvalue[i+1];
		}
	}	
	
	//ν  
	listvalue.clear();
	QString buffer2 = textEdit->toPlainText();
	listvalue = buffer2.split(QRegExp("\n"));
	
	NumberLine* textEdit1 = (((MainTextEdit*)(this->queryTab->currentWidget())))->GetNumberLine();
	QString k;
	
	QStringList mp3StrList4; 
	QString update = "CALL mp3_debug.update_watch(\'";
	for( int i = 0; i < listvalue3.count(); i++)
	{
		QString c =update + listvalue3[i] + "\'," + listvalue3[i] + "); ";
		mp3StrList4 << c;
	}
	QString buf = mp3StrList4.join(" ");
	
	qDebug()<<"listvalue.count():"<<listvalue;
	for(int i = textEdit1->list[0]; i <= listvalue.count(); i++)
	{
		QString b = b.setNum(i);
		QString trace = "CALL mp3_debug.trace(" + b + "," + b + ",2,3,mp3_stack_depth); "; 			

		if(i == textEdit1->list[0])
		{
			listvalue.replace(i-1, buf +trace + listvalue[i-1] + " ");
			numberLineReturns << i;
		}
	/*	else if( listvalue[i-1] == "")
		{
			//QSqlQuery query5("call mp3_debug.br_no++()");
			qDebug()<<"bbbbbbbbbbbb";
		}*/
		else
		{
			listvalue.replace(i-1, buf + trace + listvalue[i-1]);
			numberLineReturns << i;
		}	
	}
	listvalue.replace(0, "\n");
	listvalue.replace(2, "CREATE PROCEDURE " + procedureName + "1(" + mp3Str + ")");
	
	for(int i = 0; i < listvalue.count(); i++)
	{
		if(listvalue[i] == "BEGIN" || listvalue[i] == "begin" || listvalue[i] == "Begin")
		{
			listvalue.replace(i, "BEGIN DECLARE mp3_stack_depth INTEGER DEFAULT mp3_debug.enter_module(\'" + procedureName + "\',\'"  + dbName + "\', 7);");
			break;
		}
	}	
	
	QStringList mp3StrList5;
	for(int i = 0; i < listvalue.count(); i++)
	{
		mp3StrList5 << listvalue[i];
	}	

	QString str1 = mp3StrList5.join("\n");
	
	qDebug()<<"str1:"<<str1;
	qDebug()<<"listvalue:"<<listvalue;
	qDebug()<<"listvalue1:"<<listvalue1;
	qDebug()<<"listvalue2:"<<listvalue2;
	qDebug()<<"listvalue3:"<<listvalue3;
	qDebug()<<"numberLineReturns:"<<numberLineReturns;

	QSqlQuery query1(str1);
	QSqlError error;
	error = query1.lastError();

	qDebug()<<"error1:"<<error;
	QString str2 = "call mp3_debug.debug_on(@out_debug_id)";
	QSqlQuery query2(str2);
	
	QString str3 = "CALL mp3_debug.attach(@out_debug_id)";
	QSqlQuery query3(str3);
	
	for( int i = 0; i < textEdit1->list.count(); i++)
	{
		int j = textEdit1->list[0];
		QString buffers = buffers.setNum(j);
		QString str4 = "CALL mp3_debug.set_breakpoint(\'" + procedureName + "\',\'" + dbName + "\', 7 ," + buffers + ", -1, @out_br_no, @out_br_line)";
		QSqlQuery query4(str4);
	}	

	//  Էâ ٿ.	
	debugModeValues = new DebugModeValue(this);
	debugModeValues->show();
	
	// Docking View ٿ.
	this->breakPointerInfo->setVisible(true);
	this->callStack->setVisible(true);
	this->watches->setVisible(true);
	debuggingMode = 1;
}

/* 
STEP _ INTO 
*/
void MainForm::StepInto()
{
	MainTextEdit* mainText = (((MainTextEdit*)(this->queryTab->currentWidget())));
	mainText->setCurrentLine(numberLineReturns[numberReturn++]);

	int queryTabIndex = this->queryTab->currentIndex();
	QString procedureName1 = this->queryTab->tabText(queryTabIndex);

	int listVaue1Count = listvalue1.count();
	//   1϶
	if (listVaue1Count == 1)
	{

		QString values = debugModeValues->returnValue;
		QString str = "CALL " + procedureName1 + "1(" + values  +")";
		QSqlQuery query(str);
		qDebug()<<"str1:"<<str;
	}
	//   2϶
	else if(listVaue1Count ==2)
	{
		QString str1;
		for(int i = 0; i < debugModeValues->items.count(); i++)
		{
			QString values1 = debugModeValues->items[0]->name;
			QString values2 = debugModeValues->items[1]->name;
			QString values3 = values1 + "," + values2;
			str1 = "CALL " + procedureName1 + "1(" + values3  +")";
		}
		QSqlQuery query1(str1);
		qDebug()<<"str2:"<<str1;
	}
	//   3϶
	else if (listVaue1Count == 3)
	{
		QString str2;
		for(int i = 0; i < debugModeValues->items.count(); i++)
		{			
			QString values1 = debugModeValues->items[0]->name;
			QString values2 = debugModeValues->items[1]->name;
			QString values3 = debugModeValues->items[2]->name;
			QString values4 = values1 + "," + values2 + "," + values3;
			str2 = "CALL " + procedureName1 + "1(" + values4  +")";
		}
		QSqlQuery query2(str2);
		QSqlError error = query2.lastError();
		qDebug()<<"error:"<<error;
		qDebug()<<"str3:"<<str2;
	}

	QString str3 = "select * from mp3_debug.watches";
	QSqlQuery query3(str3);

	QString str4 = "Select * from mp3_debug.callstack";
	QSqlQuery query4(str4);

	QSqlError error;
	error = query3.lastError();

	QSqlError error1;
	error1 = query4.lastError();

	// WATCHES ̺  ִ κ
	if (error.text() == " ")
	{
		watchesInfoTable->clear();
		watchesInfoTable->setRowCount(1);
		watchesInfoTable->setColumnCount(2);
		
		int row=0;
		while(query3.next())
		{
			QString buffer1 =  query3.value(3).toString();
			QString buffer2=  query3.value(4).toString();
			
			watchesInfoTable->setItem(row++,0 , new QTableWidgetItem(buffer1));
			watchesInfoTable->setItem(row -1,1 , new QTableWidgetItem(buffer2));
			watchesInfoTable->insertRow(row);
		}
	}
	else
	{
		qDebug() << "Error";
	}

	// CALL STACK ̺  ִ κ
	if (error1.text() == " ")
	{
		callStackInfoTable->clear();
		
		while(query4.next())
		{
			QString buffer3 =  query4.value(2).toString();
			QString buffer4=  "Line : " + query4.value(5).toString();
						
			callStackInfoTable->setItem(0,0 , new QTableWidgetItem(buffer3));
			callStackInfoTable->setItem(0,1 , new QTableWidgetItem(buffer4));
		}
	}
	else
	{
		qDebug() << "Error";
	}

	QSqlQuery query5("call mp3_debug.continues(2)");

	if ( numberReturn == numberLineReturns.count()+1)
	{
		Stop();
	}
}

/* 
	 
*/
void MainForm::Stop()
{
	//   ʱȭ
	numberReturn = 0;
	
	listvalue.clear();
	listvalue1.clear();
	listvalue2.clear();
	listvalue3.clear();
	
	NumberLine* textEdit1 = (((MainTextEdit*)(this->queryTab->currentWidget())))->GetNumberLine();
	textEdit1->list.clear();
	numberLineReturns.clear();

	callStackInfoTable->clear();
	callStackInfoTable->setRowCount(1);
	callStackInfoTable->setColumnCount(2);
	
	watchesInfoTable->clear();
	watchesInfoTable->setRowCount(1);
	watchesInfoTable->setColumnCount(2);
	
	MainTextEdit* mainText = (((MainTextEdit*)(this->queryTab->currentWidget())));
	mainText->setCurrentLine(0);
	
	this->breakPointerInfo->setVisible(false);
	this->callStack->setVisible(false);
	this->watches->setVisible(false);
	
	QString str = "call mp3_debug.continues(2)";
	QSqlQuery query(str);
	QString str1 = "CALL mp3_debug.debug_off()";
	QSqlQuery query1(str1);

	ConnectionForm* connectionForm = ConnectionForm::getInstance();	
	QSqlDatabase* db = connectionForm->GetDb();	
	QString dbName = db->databaseName();
	
	//   ̸ ҷ 
	int queryTabIndex = this->queryTab->currentIndex();
	QString procedureName2 = this->queryTab->tabText(queryTabIndex);
	QString str2 = "Drop procedure " + procedureName2 + "1";
	QSqlQuery query2(str2);
	
	QSqlError error;
	error = query2.lastError();
	qDebug()<<"error:"<<error;
	QString str3 = "DELETE FROM mp3_debug.breakpoints";
	QSqlQuery query3(str3);
	error = query3.lastError();
	qDebug()<<"error:"<<error;
	QString str4 = "DELETE FROM mp3_debug.callstack";
	QSqlQuery query4(str4);
	error = query4.lastError();
	qDebug()<<"error:"<<error;
	QString str5 = "DELETE FROM mp3_debug.debuggings";
	QSqlQuery query5(str5);
	error = query5.lastError();
	qDebug()<<"error:"<<error;
	QString str6 = "DELETE FROM mp3_debug.info";
	QSqlQuery query6(str6);
	error = query6.lastError();
	qDebug()<<"error:"<<error;
	QString str7 = "DELETE FROM mp3_debug.watches";
	QSqlQuery query7(str7);
	error = query7.lastError();
	qDebug()<<"error:"<<error;

	this->debugToolBar->setVisible(false);
	debuggingMode = 0;
}

/* 
	    
*/
MainForm::~MainForm()
{
	if(this->horizontalSplitter != 0){
		delete this->horizontalSplitter;
	}
	if(this->folderView != 0){
		delete this->folderView;
	}
	if(this->verticalSplitter != 0){
		delete this->verticalSplitter;
	}
	if(this->queryTab != 0){
		delete this->queryTab;
	}
	if(this->resultTab != 0){
		delete this->resultTab;
	}
}

void MainForm::CreateTable()
{
	this->modeDialog = new IntroModeSelectDlg();
	this->modeDialog->exec();
}

void MainForm::AlterTable()
{
	QString tableName = this->folderView->currentItem()->text(0);
	singleTableInfo* tableDialog = new singleTableInfo(tableName);
	tableDialog->exec();
}

void MainForm::SetRelation()
{
	tableRelationDlg* relationDialog = new tableRelationDlg();
	relationDialog->exec();
}

void MainForm::Test()
{
	QMessageBox::warning(this, "Can't Delete", tr("Hello Everyone"), QMessageBox::Ok);
}
 
//  -----------------------------------------
void MainForm::ExcuteQeury(QString& buffer)
{
	QSqlError error;
	QSqlQuery query(buffer);
	
	error = query.lastError();
	
	// ̺  ִ κ
	if (error.text() == " "){
		
		QStringList list = buffer.split(" ");
		
		if( list[0].toLower()  == "show" ||list[0].toLower()  == "select" ){
			
			QSqlQueryModel *model = new QSqlQueryModel();
			model->setQuery(query);
			
			int i=0;
			
			this->resultTab->setCurrentIndex(0);
			((QTableView*)(this->resultTab->currentWidget()))->setModel(model);
			((QTableView*)(this->resultTab->currentWidget()))->show();
			
			QString buffer;
			QTextStream(&buffer) << i <<" row(s) affected";
			((QTextEdit*)(this->resultTab->widget(1)))->setText(buffer);
		}
		
		else {
			int i = 0;
			
			while (query.next()) {
				i++;
			}
			
			QString buffer;
			QTextStream(&buffer) << i <<" row(s) affected";
			this->resultTab->setCurrentIndex(1);
			((QTextEdit*)(this->resultTab->widget(1)))->setText(buffer);
		}
	}
	
	//  ޽ ϴ κ
	else{
		this->resultTab->setCurrentIndex(1);
		((QTextEdit*)(this->resultTab->widget(1)))->setText(error.text());
	}
}


